<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Contact extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

    }

	public function index()
	{
		$viewData = new stdClass();

		$this->load->model("City_model");
		$citys                          = $this->City_model->get_all(array());
		$this->load->model("Lang_model");
		$langs                      	= $this->Lang_model->get_all(array("isActive" => 1,"isDeleted" => 0), "","id ASC");

		$getLang 	= getLang();
		$lang_id = $this->session->userdata("lang_id");
		if(empty($lang_id)){
			$lang		= $this->Lang_model->get(array("isActive" => 1,"isDeleted" => 0, "description" => $getLang), "","id ASC");
			if (isset($lang) && $lang){
				$this->session->set_userdata('lang_id',$lang->id);
			}else{
				$this->session->set_userdata('lang_id',2);
			}

		};
		$lang_id 		= $this->session->userdata("lang_id");
		$activeLang		= $this->Lang_model->get(array("id" => $lang_id));

		//JOIN OLAYI
		$this->db->select('c.*, ct.title as cTitle, cn.title as cnTitle');
		$this->db->from('contact c');
		$this->db->join('city ct', 'c.city_id = ct.id', 'left');
		$this->db->join('county cn', 'c.county_id = cn.id', 'left');
		$this->db->order_by("c.id", "ASC");
		$this->db->where("c.lang_id", $lang_id);
		$contact = $this->db->get()->row();

		$this->load->model("Word_To_Lang_model");
		$words                      	= $this->Word_To_Lang_model->get_all(array("lang_id" => $lang_id), "", "id ASC");

        $this->db->select('p.id, p.title_'.$activeLang->description.' as title, p.location_'.$activeLang->description.' as url');
        $this->db->from('value p');
        $this->db->where("p.isActive", 1);
        $this->db->order_by("p.id", "ASC");
        $values = $this->db->get()->result();

        $this->db->select('s.id, s.img_url, s.title_'.$activeLang->description.' as title, s.description_'.$activeLang->description.' as description, s.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('s.seo_des_'.$activeLang->description.' as seo_des, s.seo_title_'.$activeLang->description.' as seo_title, s.icon');
        $this->db->from('service s');
        $this->db->order_by("s.rank", "ASC");
        $this->db->where("s.isActive", 1);
        $services = $this->db->get()->result();

        $this->db->select('i.id, i.img_url, i.title_'.$activeLang->description.' as title, i.description_'.$activeLang->description.' as description, i.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('i.seo_des_'.$activeLang->description.' as seo_des, i.seo_title_'.$activeLang->description.' as seo_title, i.icon');
        $this->db->from('industry i');
        $this->db->order_by("i.rank", "ASC");
        $this->db->where("i.isActive", 1);
        $industrys = $this->db->get()->result();

		$viewData->contact              = $contact;
		$viewData->citys                = $citys;
		$viewData->langs            	= $langs;
		$viewData->lang_id          	= $lang_id;
		$viewData->words            	= $words;
		$viewData->values				= $values;
		$viewData->services				= $services;
		$viewData->industrys		    = $industrys;
		$viewData->activeLang 			= $activeLang;
		$viewData->activePage           = "contact";


		$viewData->seo_title            = $contact->seo_title;
		$viewData->seo_key              = $contact->seo_key;
		$viewData->seo_des              = $contact->seo_des;

		$this->load->view('pages/contact/index', $viewData);
	}


	public function getContactUs(){


		if($_POST){
			$response=$_POST["g-recaptcha-response"];
			$secret="6Lfflz0qAAAAANW5GeQ0LgZ5LfraXOTu7UVdeQPF";
			$remoteip=$_SERVER["REMOTE_ADDR"];
			$captcha=file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$response&remoteip=$remoteip");
			$result=json_decode($captcha);
			if($result->success != 1){
				setErrorAlert("Lütfen Güvenlik işlemini tamamlayınız.");
				goback();
			}

		}

		$name           	= strip_tags(trim($this->input->post("formName")));
		$phone          	= strip_tags(trim($this->input->post("formPhone")));
		$message        	= $this->input->post("formMessage");
		$ip             	= $this->input->ip_address();
		$date           	= date('d.m.Y H:i:s');

		$mail_message = "
			<!DOCTYPE html>
			<html>
			<body>
			<h2>Profive Gayrimenkul Yatırım Danışmanlığı - İletişim Platformu</h2>
			Adı Soyadı : $name <br>
			Telefon numarası : $phone <br>
			Mesaj : $message <br>
			</body>
			</html>";
			
		$this->load->model("Email_model");
		$email = $this->Email_model->get(array("isActive" => 1));

		if ($email) {

			$mail = array(
				"subject"   => "Profive Gayrimenkul Yatırım Danışmanlığı - İletişim Platformu",
				"message"   => $mail_message,
				"attach"    => ""
			);

			$email_status = sendMail(array("email" => "info@profivegroup.com", "cc" => "", "bcc" => ""), $mail);

			if ($email_status) {
				setSuccessAlert("Bizimle iletişime geçtiğiniz için teşekkür ederiz. En kısa sürede geri dönüş sağlayacağız.");
				redirect(base_url("basarili"));
			} else {
				setErrorAlert("Mesajınız gönderilirken bir hata oluştu");
				goback();

			}

		}
	}
}
