<?php


Class Brand_model extends CI_Model
{


    public function __construct()
    {
        parent::__construct();

        $this->db = $this->load->database('default', TRUE);
        $this->pageConf = $this->config->item("Brand", "pages");

    }

    public function add($data)
    {

        $insert = $this->db
            ->insert($this->pageConf["table"], $data);
        return $insert;

    }

    public function get($where = array())
    {

        if (!empty($where)) {
            $this->db->where($where);
        }

        $row = $this->db
            ->get($this->pageConf["table"])
            ->row();

        return $row;

    }

    public function get_all($where = array(), $limit="", $order_by = "")
    {

        if (!empty($where)) {
            $this->db->where($where);
        }

        if (!empty($order_by)) {
            $this->db->order_by($order_by);
        }


        if ($limit) {

            $rows = $this->db
                ->get($this->pageConf["table"], $limit)
                ->result();

        } else {

            $rows = $this->db
                ->get($this->pageConf["table"])
                ->result();

        }

        return $rows;

    }

    public function delete($where = array())
    {

        if (!empty($where)) {
            $this->db->where($where);
        }

        $delete = $this->db
            ->delete($this->pageConf["table"]);

        return $delete;

    }

    public function update($data = array(), $where = array())
    {

        if (!empty($where)) {
            $this->db->where($where);
        }

        $update = $this->db
            ->update($this->pageConf["table"], $data);

        return $update;

    }

    public function query($query){

        return $this->db->query($query)->result();

    }

}


