<!DOCTYPE html>
<html class="no-js" lang="<?php echo $activeLang->description; ?>">

<head>
    <?php $this->load->view("includes/head"); ?>
    <?php $this->load->view("includes/include_style"); ?>
    <?php $this->load->view("services/page_style"); ?>
</head>

<body data-mobile-nav-style="classic">
<header>
    <nav class="navbar navbar-expand-lg header-transparent bg-transparent header-reverse" data-header-hover="light">
        <div class="container-fluid">
            <?php $this->load->view("includes/logo"); ?>
            <?php $this->load->view("includes/menu"); ?>
            <?php $this->load->view("includes/menu_right"); ?>
        </div>
    </nav>
</header>

<section class="section-dark p-0 bg-dark-gray">
        <?php $this->load->view("services/breadcrumb"); ?>
</section>

<section>
    <div class="container">
        <?php $this->load->view("services/top_section"); ?>
    </div>
</section>

<section class="bg-very-light-gray overlap-height position-relative background-position-center background-repeat" style="background-image: url('<?php echo base_url(); ?>assets/images/vertical-center-line-bg-dark.svg')">
    <div class="container overlap-gap-section">
        <?php $this->load->view("dashboard/services"); ?>
    </div>
</section>

<section class="pb-4">
    <div class="container">
        <?php $this->load->view("services/testimonial"); ?>
    </div>
</section>


<section class="bg-gradient-green-transparent">
    <div class="container">
        <?php $this->load->view("includes/blog"); ?>
    </div>
</section>

<footer class="bg-dark-gray pb-30px">
    <div class="container">
        <?php $this->load->view("includes/footer"); ?>
    </div>
</footer>


<?php $this->load->view("includes/include_script"); ?>
<?php $this->load->view("services/page_script"); ?>
</body>

</html>